const express = require("express");
const router = express.Router();
const passport = require("passport");

const {
  getPlans,
  createPlans,
  createProduct,
  getProducts,
  createSubscription,
  getSubscriptions,
  getSingleSubscription,
  updatePlan,
  createSubDB,
  getSingleSubscriptionAdmin,
  getClientId,
} = require("../controller/paymentController");

// /* GET home page. */
router.post("/products/create", createProduct);
router.post("/plans/create", createPlans);
router.post(
  "/subscriptions/create",
  passport.authenticate("jwt", { session: false }),
  createSubscription
);
router.post(
  "/create/subscription-db",
  passport.authenticate("jwt", { session: false }),
  createSubDB
);
router.put("/plans/update/:planId", updatePlan);
router.get("/products", getProducts);
router.get("/plans", getPlans);
router.get("/subscriptions/:subId", getSingleSubscription);
router.get("/subscription/admin/:id", getSingleSubscriptionAdmin);
router.get("/subscriptions", getSubscriptions);
router.get("/client-id", getClientId);

module.exports = router;
