const express = require("express");
const path = require("path");
const router = express.Router();
const passport = require("passport");
const multer = require("multer");
const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    console.log({ fileType: file });
    const fileType = (file.mimetype.includes("audio") && "audio") || "images";
    const destinationPath = `public/${fileType}/`;
    cb(null, destinationPath);
  },
  filename: function (req, file, cb) {
    cb(
      null,
      file.fieldname + "-" + Date.now() + path.extname(file.originalname)
    );
  },
});
const upload = multer({ storage });
const {
  getAllMemorialAdmin,
  getAllMemorial,
  createMemorial,
  updateCoverPhotoMemorial,
  updateProfileImageMemorial,
  getMemorialsByUserId,
  updateMemorial,
  deleteMemorial,
  getMemorialsByAddress,
  getMemorialById,
  index,
  suspendMemorial,
  unsuspendMemorial,
  getPinnedMemorials,
  pinMemorial,
  unpinMemorial,
  addView,
  getByCategory,
  updateCover,
  updateMemorialRenewal
} = require("../controller/memorialController");
const {
  uploadProfileImage,
  uploadVideo,
  uploadAudio,
  uploadImage,
} = require("../middlewares/upload.middleware");
const {
  createMediaContent,
  getAllMediaContentOfMemorial,
  createYtContent,
  createAudioBackground,
  getBGAudioMemorial,
  updateAudioBackground,
} = require("../controller/MediaContentController");
const {
  checkCoAdmin,
  checkSuperAdmin,
  checkMemorialOwner,
} = require("../middlewares/user.middleware");

router.get("/all_memorials_admin", getAllMemorialAdmin);
router.get("/all", getAllMemorial);
router.get("/pinned", getPinnedMemorials);
router.post(
  "/creatememorial",
  upload.fields([
    { name: "ProfileImgUrl", maxCount: 1 },
    { name: "coverPhoto", maxCount: 1 },
    { name: "audio", maxCount: 1 },
  ]),
  createMemorial
);
router.post(
  "/upload/cover",
  upload.single("file"),
  updateCoverPhotoMemorial
);
router.post(
  "/upload/profile",
  upload.single("file"),
  updateProfileImageMemorial
);
router.post(
  "/upload/images/:memorialId",
  upload.single("file"),
  createMediaContent
);
router.post(
  "/upload/audio/:memorialId",
  upload.single("audio"),
  createMediaContent
);
router.post(
  "/upload/audio-background/:memorialId",
  upload.single("audio"),
  createAudioBackground
);
router.put(
  "/update/audio-background/:memorialId",
  upload.single("audio"),
  updateAudioBackground
);
router.post("/upload/videos/:memorialId", createYtContent);
router.delete(
  "/remove/:memorialId",
  passport.authenticate("jwt", { session: false }),
  checkMemorialOwner,
  deleteMemorial
);
router.get("/by-user/:userId", getMemorialsByUserId);
router.get("/by-category/:categoryId", getByCategory);
router.get("/single-memorial/:id", getMemorialById);
router.get("/gallery", getAllMediaContentOfMemorial);
router.get("/get/:address", getMemorialsByAddress);
router.put(
  "/updateMemorial/:memorialId",
    upload.fields([
    { name: "ProfileImgUrl", maxCount: 1 },
    { name: "coverPhoto", maxCount: 1 },
    { name: "audio", maxCount: 1 },
  ]),
  updateMemorial
);
router.put(
  "/update/cover/:memorialId",
  passport.authenticate("jwt", { session: false }),
  checkCoAdmin,
  upload.single("file"),
  updateCover
);
router.put(
  "/suspend/:id",
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  suspendMemorial
);
router.put(
  "/unsuspend/:id",
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  unsuspendMemorial
);
router.put(
  "/pin/:id",
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  pinMemorial
);
router.put(
  "/unpin/:id",
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  unpinMemorial
);
router.put("/add-view/:id", addView);
router.get("/background-audio/:memorialId", getBGAudioMemorial);
router.get("/", index);

router.put("/:id/renewal", passport.authenticate("jwt", { session: false }),
  checkSuperAdmin, updateMemorialRenewal);

module.exports = router;
