const express = require("express");
const router = express.Router();
const path = require("path");
const {
  index,
  getSingleMedia,
  updateMediaImage,
  updateMediaAudio,
  removeMediaContent,
  getAllMediaByUser,
} = require("../controller/MediaContentController");
const multer = require("multer");
const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    const fileType = req.body.fileType || "images";
    const destinationPath = `public/${fileType}/`;
    cb(null, destinationPath);
  },
  filename: function (req, file, cb) {
    cb(
      null,
      file.fieldname + "-" + Date.now() + path.extname(file.originalname)
    );
  },
});
const upload = multer({ storage });

router.put("/update/images/:id", upload.single("file"), updateMediaImage);
router.put("/update/audio/:id", upload.single("file"), updateMediaAudio);
router.delete("/remove/:id", removeMediaContent);

router.get("/single/:id", getSingleMedia);
router.get("/by-user/:id", getAllMediaByUser);
router.get("/", index);

module.exports = router;
