const express = require("express");
const router = express.Router();
const path = require("path");

const {
  create,
  getJourneyByMemorial,
  getJourneysByCoAdmins,
  index,
  getJourney,
  updateJourney,
  removeJourney,
} = require("../controller/journeys");
const multer = require("multer");
const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    const fileType = req.fileType || "images";
    const destinationPath = `public/${fileType}/`;
    cb(null, destinationPath);
  },
  filename: function (req, file, cb) {
    cb(
      null,
      file.fieldname + "-" + Date.now() + path.extname(file.originalname)
    );
  },
});
const upload = multer({ storage });

router.post("/create", upload.single("image"), create);

router.put("/update/:id", upload.single("image"), updateJourney);

router.delete("/remove/:id", removeJourney);

router.get("/get-by-memorial/:memorialId", getJourneyByMemorial);

router.get("/by-coadmin/:userId", getJourneysByCoAdmins);

router.get("/journey/:id", getJourney);

router.get("/", index);

module.exports = router;
