const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const User = require("./User"); // Import the User model
const Obituary = require("./Obituary");

const ObituaryPurchase = sequelize.define(
  "ObituaryPurchase",
  {
    obituary_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: Obituary,
        key: "id",
      },
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: User,
        key: "userid",
      },
    },
    paymentId: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    details: {
      type: DataTypes.TEXT("long"),
    },
  },
  {
    tableName: "obituary_purchase",
    timestamps: true,
  }
);

// Define association with User model

ObituaryPurchase.belongsTo(User, {
  foreignKey: "user_id",
  as: "user",
});

ObituaryPurchase.belongsTo(Obituary, {
  foreignKey: "obituary_id",
  as: "obituary",
});

// async function migrate() {
//   try {
//     await Subscription.sync({ force: true });
//     console.log("Migration successful");
//   } catch (error) {
//     console.error("Migration failed:", error);
//   }
// }

// migrate();

module.exports = ObituaryPurchase;
