const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const Tribute = require("./TraibuteModel"); // adjust if needed

const TributeShare = sequelize.define("TributeShare", {
  id: { type: DataTypes.INTEGER, primaryKey: true, autoIncrement: true },
  tribute_id: { type: DataTypes.INTEGER, allowNull: false },
  ip_address: { type: DataTypes.STRING }, // Optional
}, {
  tableName: "tribute_shares",
  timestamps: true,
  createdAt: "shared_at",
  updatedAt: false,
});

// ⬇️ Define the relationship here
TributeShare.belongsTo(Tribute, {
  foreignKey: 'tribute_id',
  targetKey: 'id',
  onDelete: 'CASCADE',
});

module.exports = TributeShare;
