const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const User = require("./User");
const ObituariesAudioBG = require("./ObituariesAudioBG");

const Obituary = sequelize.define(
  "Obituary",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: User,
        key: "userid",
      },
    },

    obituaryTitle: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    Firstname: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    MiddleName: DataTypes.STRING,
    LastName: DataTypes.STRING,
    Gender: DataTypes.STRING,

    // Profile + Slide
    ProfileImgUrl: DataTypes.STRING,
    SlideImage: DataTypes.STRING,

    // Extra uploaded images
    image1: {
      type: DataTypes.STRING,
    },
    image2: {
      type: DataTypes.STRING,
    },
    image3: {
      type: DataTypes.STRING,
    },

    DateOfBirth: DataTypes.DATE,
    DateOfDeath: DataTypes.DATE,

    Relationship: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    MemorialDesignation: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    MemorialAddress: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    PrivacyOptions: DataTypes.STRING,
    Plan: DataTypes.STRING,

    townBorn: DataTypes.STRING,
    cityBorn: DataTypes.STRING,
    countryBorn: DataTypes.STRING,

    townDeath: DataTypes.STRING,
    cityDeath: DataTypes.STRING,
    countryDeath: DataTypes.STRING,
    placeOfDeath: DataTypes.STRING,

    CreatedOn: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },

    Title: DataTypes.TEXT("long"),
    description: DataTypes.TEXT("long"),

    pinned: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    daily: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    type: {
      type: DataTypes.ENUM("pinned", "daily"),
      allowNull: false,
      defaultValue: "pinned",
    },
    days: {
      type: DataTypes.INTEGER,
      defaultValue: 3,
    },
    suspended: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    views: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
  },
  {
    tableName: "obituary", // ✅ match your DB table
    timestamps: false,
  }
);

// Relation
Obituary.belongsTo(User, { foreignKey: "user_id", as: "user" });
Obituary.hasOne(ObituariesAudioBG, {
  foreignKey: "obituaries_id",
  as: "audioBg",
});
module.exports = Obituary;
