// models/HelpThreadParticipant.js
const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const User = require("./User"); // :contentReference[oaicite:1]{index=1}
const HelpThread = require("./HelpThread");

const HelpThreadParticipant = sequelize.define("HelpThreadParticipant", {
  id: { type: DataTypes.INTEGER, primaryKey: true, autoIncrement: true },
  thread_id: {
    type: DataTypes.INTEGER,
    allowNull: false,
    references: { model: HelpThread, key: "id" },
  },
  user_id: {
    type: DataTypes.INTEGER,
    allowNull: false,
    references: { model: User, key: "userid" },
  },
  // optional: unread counts per participant
  last_read_at: { type: DataTypes.DATE, allowNull: true },
}, {
  tableName: "help_thread_participants",
  timestamps: true,
});
module.exports = HelpThreadParticipant;
