// models/Anniversary.js

const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const User = require("./User");
const Memorial = require("./Memorial");

const Anniversary = sequelize.define(
  "Anniversary",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: User,
        key: "userid",
      },
    },
    title: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    description: {
      type: DataTypes.TEXT("long"),
    },
    memorial_id: {
      type: DataTypes.INTEGER,
      references: {
        model: Memorial,
        key: "id",
      },
    },
  },
  {
    tableName: "anniversaries",
    timestamps: true,
  }
);

Anniversary.belongsTo(User, { foreignKey: "user_id", as: "user" });
Anniversary.belongsTo(Memorial, { foreignKey: "memorial_id", as: "memorial" });



module.exports = Anniversary;
