const Service = require("../models/Service");


// naya service create karne ka function
exports.createService = async (req, res) => {
  try {
    const { name } = req.body;

    if (!name) {
      return res.status(400).json({ message: "Service ka naam required hai." });
    }

    const service = await Service.create({ name });
    return res.status(201).json(service);

  } catch (error) {
    console.error("Error createService:", error);
    res.status(500).json({ message: "Server error" });
  }
};

// sari services list karne ka function
exports.getAllServices = async (req, res) => {
  console.log("passes")
  try {
    const services = await Service.findAll();
    res.status(200).json(services);
  } catch (error) {
    console.error("Error getAllServices:", error);
    res.status(500).json({ message: "Server error" });
  }
};

// ek service update karne ka function
exports.updateService = async (req, res) => {
  try {
    const { id } = req.params;
    const { name } = req.body;

    const service = await Service.findByPk(id);
    if (!service) {
      return res.status(404).json({ message: "Service nahi mili" });
    }

    service.name = name || service.name;
    await service.save();

    res.status(200).json(service);
  } catch (error) {
    console.error("Error updateService:", error);
    res.status(500).json({ message: "Server error" });
  }
};

// ek service delete karne ka function
exports.deleteService = async (req, res) => {
  try {
    const { id } = req.params;

    const service = await Service.findByPk(id);
    if (!service) {
      return res.status(404).json({ message: "Service nahi mili" });
    }

    await service.destroy();
    res.status(200).json({ message: "Service delete ho gayi" });
  } catch (error) {
    console.error("Error deleteService:", error);
    res.status(500).json({ message: "Server error" });
  }
};

exports.getServiceById = async (req, res) => {
  try {
    const { id } = req.params;
    const service = await Service.findByPk(id);

    if (!service) {
      return res.status(404).json({ message: "Service nahi mili" });
    }

    res.status(200).json(service);
  } catch (error) {
    console.error("Error getServiceById:", error);
    res.status(500).json({ message: "Server error" });
  }
};