const { Op } = require("sequelize");
const CoAdmins = require("../models/CoAdmins");
const Memorial = require("../models/Memorial");
const User = require("../models/User");

module.exports = {
  async create(req, res) {
    try {
      const foundUser = await User.findOne({
        where: { email: req.body.email },
      });
      console.log({ foundUser: foundUser.userid });
      if (!foundUser)
        return res
          .status(400)
          .json({ message: "User with that email not found" });
      const foundCoAdmins = await CoAdmins.findOne({
        where: { memorial_id: req.body.memorial_id, user_id: foundUser.userid },
      });
      if (foundCoAdmins)
        return res
          .status(400)
          .json({ message: "Admin cooperation already exists!" });
      const coAdmin = await CoAdmins.create({
        user_id: foundUser.userid,
        memorial_id: req.body.memorial_id,
      });
      return res.json({ message: "Created new co-admins", coAdmin });
    } catch (err) {
      console.log({ err });
    }
  },

  async index(req, res) {
    try {
      const page = req.query.page ? req.query.page : 1;
      const pageSize = req.query.pageSize ? req.query.pageSize : 4;
      const coAdmins = await CoAdmins.findAndCountAll({
        where: {
          ...(req.query.search && {
            [Op.or]: [
              { "$User.firstName$": { [Op.regexp]: req.query.search } },
              { "$User.lastName$": { [Op.regexp]: req.query.search } },
              { "$User.email$": { [Op.regexp]: req.query.search } },
              { "$Memorial.Firstname$": { [Op.regexp]: req.query.search } },
              { "$Memorial.MiddleName$": { [Op.regexp]: req.query.search } },
              { "$Memorial.LastName$": { [Op.regexp]: req.query.search } },
            ],
          }),
        },
        order: [["createdAt", "DESC"]],
        limit: parseInt(pageSize),
        offset: (parseInt(page) - 1) * parseInt(pageSize),
        include: [
          { model: Memorial, as: "memorial" },
          { model: User, as: "user" },
        ],
      });
      const total = Math.ceil(coAdmins.count / pageSize);
      return res.json({
        filters: { page: parseInt(page), nextPage: parseInt(page) + 1, total },
        coAdmins: coAdmins.rows,
      });
    } catch (err) {
      console.log({ err });
    }
  },

  async getCoAdminByUser(req, res) {
    try {
      const admins = await CoAdmins.findOne({
        where: { user_id: req.params.id },
        include: [
          { model: User, as: "user" },
          { model: Memorial, as: "memorial" },
        ],
      });
      return res.json(admins);
    } catch (err) {
      console.log([err]);
    }
  },

  async getCoAdminByMemorial(req, res) {
    try {
      const admins = await CoAdmins.findAll({
        where: { memorial_id: req.params.id },
        include: [{ model: User, as: "user" }],
      });
      return res.json(admins);
    } catch (err) {
      console.log([err]);
    }
  },

  async removeCoAdmins(req, res) {
    console.log({ body: req.params });
    try {
      await CoAdmins.destroy({
        where: {
          user_id: req.params.userId,
          memorial_id: req.params.memorialId,
        },
      });
      return res.json({ message: "Removed the cooperation successfully!" });
    } catch (err) {
      console.log([err]);
    }
  },
};
