const express = require("express");
const router = express.Router();
const passport = require("passport");
const ctrl = require("../controller/helpCenter.controller");

// All Help Center routes require authentication via JWT
router.post(
  "/threads",
  passport.authenticate("jwt", { session: false }),
  ctrl.createThread
);

router.get(
  "/threads",
  passport.authenticate("jwt", { session: false }),
  ctrl.listMyThreads
);

router.get(
  "/threads/:id",
  passport.authenticate("jwt", { session: false }),
  ctrl.getThread
);

router.post(
  "/threads/:id/messages",
  passport.authenticate("jwt", { session: false }),
  ctrl.replyToThread
);

router.get(
  "/unread-count",
  passport.authenticate("jwt", { session: false }),
  ctrl.unreadCount
);

module.exports = router;
