// models/index.js

// --- Core models ---
const User = require("./User");
const Category = require("./Category");
const Memorial = require("./Memorial");
const Traibute = require("./TraibuteModel");
const Anniversary = require("./Anniversary");
const Obituary = require("./Obituary");
// Tribute Likes model
const TributeLike = require("./TributeLike");
const ObituariesAudioBG = require("./MemorialAudioBG");
// --- Help Center models ---
const HelpThread = require("./HelpThread");
const HelpMessage = require("./HelpMessage");
const HelpThreadParticipant = require("./HelpThreadParticipant");

// -----------------------------
// Core associations
// -----------------------------

// User ↔ Category
User.hasMany(Category, { foreignKey: "user_id", as: "categories" });
Category.belongsTo(User, { foreignKey: "user_id", as: "owner" });

// Category ↔ Memorial
Category.hasMany(Memorial, { foreignKey: "category_id", as: "memorials" });
Memorial.belongsTo(Category, { foreignKey: "category_id", as: "category" });

// User ↔ Memorial
User.hasMany(Memorial, { foreignKey: "user_id", as: "memorials" });
Memorial.belongsTo(User, { foreignKey: "user_id", as: "owner" });

// User ↔ Traibute
User.hasMany(Traibute, { foreignKey: "user_id", as: "tribute" });
Traibute.belongsTo(User, { foreignKey: "user_id", as: "user" });

// Memorial ↔ Traibute
Memorial.hasMany(Traibute, { foreignKey: "memorail_id", as: "memorialTributes" });
Traibute.belongsTo(Memorial, { foreignKey: "memorail_id", as: "memorial" });

// Obituary ↔ Traibute
Obituary.hasMany(Traibute, { foreignKey: "memorail_id", as: "obituaryTributes" });
Traibute.belongsTo(Obituary, { foreignKey: "memorail_id", as: "obituary" });


// Traibute ↔ TributeLike
Traibute.hasMany(TributeLike, { foreignKey: "tribute_id", as: "likes" });
TributeLike.belongsTo(Traibute, { foreignKey: "tribute_id", as: "tribute" });

// -----------------------------
// Help Center associations
// -----------------------------

HelpThread.hasMany(HelpMessage, { foreignKey: "thread_id", as: "messages" });
HelpMessage.belongsTo(HelpThread, { foreignKey: "thread_id", as: "thread" });

HelpThread.belongsTo(User, { foreignKey: "created_by", as: "creator" });
HelpMessage.belongsTo(User, { foreignKey: "sender_id", as: "sender" });

HelpThread.hasMany(HelpThreadParticipant, { foreignKey: "thread_id", as: "participants" });
HelpThreadParticipant.belongsTo(HelpThread, { foreignKey: "thread_id", as: "thread" });
HelpThreadParticipant.belongsTo(User, { foreignKey: "user_id", as: "participant" });

// User ↔ Anniversary
User.hasMany(Anniversary, { foreignKey: "user_id", as: "anniversaries" });
Memorial.hasMany(Anniversary, { foreignKey: "memorial_id", as: "anniversaries" });


Obituary.hasMany(ObituariesAudioBG, {
  foreignKey: "obituaries_id",
  as: "audioFiles",
});
ObituariesAudioBG.belongsTo(Obituary, {
  foreignKey: "obituaries_id",
  as: "obituary",
});
// -----------------------------
// Export all models in one place
// -----------------------------
module.exports = {
  User,
  Category,
  Memorial,
  Traibute,
  TributeLike,
  Anniversary,
  HelpThread,
  HelpMessage,
  HelpThreadParticipant,
  Obituary,
};
