const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");

const Traibute = sequelize.define(
  "Traibute",
  {
    id: { type: DataTypes.INTEGER, primaryKey: true, autoIncrement: true },
    userId: {
      type: DataTypes.INTEGER,
      allowNull: false,
      field: "user_id",
    },
    memorailId: {
      type: DataTypes.INTEGER,
      allowNull: false,
      field: "memorail_id",
    },
    postType: {
      type: DataTypes.STRING,
      allowNull: true,
      field: "postType", // "memorial" or "obituary"
    },
    isActive: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: true,
      field: "IsActive",
    },
    createdBy: { type: DataTypes.STRING, field: "CreatedBy" },
    createdOn: { type: DataTypes.DATE, field: "CreatedOn" },
    traibuteIcon: { type: DataTypes.STRING, field: "TraibuteIcon" },
    reviewDescription: { type: DataTypes.TEXT("long"), field: "ReviewDescription" },
  },
  {
    tableName: "traibute",
    timestamps: false,
  }
);

module.exports = Traibute;
