// models/TextContent.js
const { DataTypes } = require('sequelize');
const sequelize = require('../config/database');
const Memorial = require('./Memorial'); // Import the Memorial model

const TextContent = sequelize.define('TextContent', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true,
    allowNull: false
  },
  content_key: {
    type: DataTypes.STRING,
    allowNull: false
  },
  content: {
    type: DataTypes.TEXT('long'),
    allowNull: false
  },
  memorial_id: {
    type: DataTypes.INTEGER,
    references: {
      model: Memorial,
      key: 'id'
    }
  }
}, {
  tableName: 'text_content',
  timestamps: false
});

module.exports = TextContent;
