// models/Journey.js

const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const User = require("./User"); // Import the User model
const Memorial = require("./Memorial");

const ServiceDetail = sequelize.define(
  "ServiceDetail",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: User,
        key: "userid",
      },
    },

    type: {
      type: DataTypes.STRING,
      allowNull: false,
      defaultValue: "CoffinServices", // default agar na aaye
    },
    title: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    image: {
      type: DataTypes.STRING,
    },
    description: {
      type: DataTypes.TEXT("long"),
    },
    service_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "service_id",
      },
    },
    nextRenewal: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    lastRenewed: {
      type: DataTypes.DATE,
      allowNull: true,
    },

    suspended: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
  },
  {
    tableName: "serviceDetail",
    timestamps: true,
  }
);

ServiceDetail.belongsTo(User, { foreignKey: "user_id", as: "user" });
ServiceDetail.belongsTo(User, { foreignKey: "service_id", as: "serviceId" });

// Journey.sync({ alter: true });
//   .then(() => {
//     console.log("New table created.");
//   })
//   .catch((error) => {
//     console.error("Error creating new table:", error);
//   });

// const tableName = "journey";
// const query = `SHOW TABLES LIKE '${tableName}'`;

// function timer() {
//   setTimeout(() => {
//     sequelize
//       .query(query)
//       .then((results) => {
//         if (results.length === 0) {
//           Journey.sync({ force: false })
//             .then(() => {
//               console.log("New table created.");
//             })
//             .catch((error) => {
//               console.error("Error creating new table:", error);
//             });
//         } else {
//           console.log("Table already exists.");
//         }
//       })
//       .catch((error) => {
//         console.error("Error checking table existence:", error);
//       });
//   }, 2000);
// }
// timer();

module.exports = ServiceDetail;
