const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");

const Promocode = sequelize.define(
  "Promocode",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    code: {
      type: DataTypes.STRING,
      allowNull: false,
      unique: true,
    },
    discount: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
  },
  {
    tableName: "promocode",
    timestamps: true,
  }
);

module.exports = Promocode;
