// models/MemorialAudioBG.js

const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const Memorial = require("./Memorial");

const MemorialAudioBG = sequelize.define(
  "MemorialAudioBG",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    audio: {
      type: DataTypes.STRING,
    },
    memorial_id: {
      type: DataTypes.INTEGER,
      references: {
        model: Memorial,
        key: "id",
      },
    },
  },
  {
    tableName: "memorial_audio_bg",
    timestamps: true,
  }
);

MemorialAudioBG.belongsTo(Memorial, {
  foreignKey: "memorial_id",
  as: "memorial",
});

module.exports = MemorialAudioBG;
