const { DataTypes, Model } = require("sequelize");
// const sequelize = require("../config/database");
const path = require("path");
const sequelize = require(path.join(__dirname, "../config/database"));
const User = require("./User");



const Category = require(path.join(__dirname, "Category"));



const Memorial = sequelize.define(
  "Memorial",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: User,
        key: "userid",
      },
    },
    category_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Category,
        key: "id",
      },
    },

    memorialTitle:{
      type:DataTypes.STRING,
      allowNull:true,

    },
    Firstname: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    MiddleName: {
      type: DataTypes.STRING,
    },
    LastName: {
      type: DataTypes.STRING,
    },
    Gender: {
      type: DataTypes.STRING,
    },
    ProfileImgUrl: {
      type: DataTypes.STRING,
    },
    coverPhoto: {
      type: DataTypes.STRING,
    },
    audio: {
      type: DataTypes.STRING,
    },
    DateOfBirth: {
      type: DataTypes.DATE,
    },
    DateOfDeath: {
      type: DataTypes.DATE,
    },
    Relationship: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    MemorialDesignation: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    MemorialAddress: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    PrivacyOptions: {
      type: DataTypes.STRING,
    },
    Plan: {
      type: DataTypes.STRING,
    },
    CreatedBy: {
      type: DataTypes.STRING,
    },
    CreatedOn: {
      type: DataTypes.DATE,
      defaultValue: new Date(),
    },
    townBorn: {
      type: DataTypes.STRING,
    },
    cityBorn: {
      type: DataTypes.STRING,
    },
    countryBorn: {
      type: DataTypes.STRING,
    },
    townDeath: {
      type: DataTypes.STRING,
    },
    cityDeath: {
      type: DataTypes.STRING,
    },
    countryDeath: {
      type: DataTypes.STRING,
    },
    Title: {
      type: DataTypes.TEXT("long"),
    },
    suspended: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    pinned: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    views: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    nextRenewal: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    lastRenewed: {
      type: DataTypes.DATE,
      allowNull: true,
    },
  },
  {
    tableName: "memorial",
    timestamps: false,
  }
);



module.exports = Memorial;
