// models/MediaContent.js
const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const Memorial = require("./Memorial"); // Import the Memorial model

const MediaContent = sequelize.define(
  "MediaContent",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    content_key: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    fileType: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    filePath: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    memorial_id: {
      type: DataTypes.INTEGER,
      references: {
        model: Memorial,
        key: "id",
      },
    },
    title:{
      type:DataTypes.STRING,
       allowNull: true,

    },
    description:{
      type:DataTypes.STRING,
       allowNull: true,

    }

  },
  {
    tableName: "media_content",
    timestamps: false,
  }
);

MediaContent.belongsTo(Memorial, { foreignKey: "memorial_id", as: "memorial" });

module.exports = MediaContent;
