// models/HelpThread.js
const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const User = require("./User"); // :contentReference[oaicite:0]{index=0}

const HelpThread = sequelize.define("HelpThread", {
  id: { type: DataTypes.INTEGER, primaryKey: true, autoIncrement: true },
  subject: { type: DataTypes.STRING, allowNull: false },
  created_by: {
    type: DataTypes.INTEGER,
    allowNull: false,
    references: { model: User, key: "userid" },
  },
  scope: {
    // who this is about / target audience classification
    type: DataTypes.ENUM("obituary_admins", "memorial_admins", "service_providers", "custom"),
    allowNull: false,
    defaultValue: "custom",
  }
}, {
  tableName: "help_threads",
  timestamps: true,
});
module.exports = HelpThread;
