// models/CoAdmins.js

const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const User = require("./User"); // Import the User model
const Memorial = require("./Memorial");

const CoAdmins = sequelize.define(
  "CoAdmins",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: User,
        key: "userid",
      },
    },
    memorial_id: {
      type: DataTypes.INTEGER,
      references: {
        model: Memorial,
        key: "id",
      },
    },
  },
  {
    tableName: "co_admins",
    timestamps: true,
  }
);

CoAdmins.belongsTo(Memorial, { foreignKey: "memorial_id", as: "memorial" });

module.exports = CoAdmins;
