const { DataTypes } = require("sequelize");
const path = require("path");
// const sequelize = require("../config/database");
const sequelize = require(path.join(__dirname, "../config/database"));
const User = require("./User");
console.log({ sequelize });

const Category = sequelize.define(
  "Category",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    title: {
      type: DataTypes.STRING,
      allowNull: false,
    },
     quote: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    user_id: {
          type: DataTypes.INTEGER,
          allowNull: false,
          references: {
            model: User,
            key: "userid",
          },
        },
    image: {
      type: DataTypes.STRING,
    },
  },
  {
    tableName: "category",
    timestamps: true,
  }
);

module.exports = Category;
