const jwt = require("jsonwebtoken");

module.exports = (req, res, next) => {
  try {
    const authHeader = req.headers["authorization"];
    if (!authHeader) {
      return res.status(401).json({ error: "Authorization header missing" });
    }

    const token = authHeader.split(" ")[1];
    if (!token) {
      return res.status(401).json({ error: "Token missing" });
    }

    // 👇 must use SAME secret as signing
    const decoded = jwt.verify(token, process.env.SECRETKEY);

    req.user = decoded; // attach payload
    next();
  } catch (err) {
    console.error("JWT verify failed:", err.message);
    res.status(401).json({ error: "Invalid or expired token" });
  }
};
