const TributeShare = require("../models/TributeShare");

exports.getShares = async (req, res) => {
  try {
    const tributeId = req.params.id;
    const count = await TributeShare.count({ where: { tribute_id: tributeId } });
    res.status(200).json({ shares: count });
  } catch (err) {
    res.status(500).json({ error: "Error fetching share count" });
  }
};

exports.addShare = async (req, res) => {
  try {
    const { id: tributeId } = req.params;
    const ip = req.ip;
    await TributeShare.create({ tribute_id: tributeId, ip_address: ip });
    res.status(201).json({ message: "Share counted" });
  } catch (err) {
    console.log("err",err);
    res.status(500).json({ error: "Error saving share" });
  }
};
