const { Op } = require("sequelize");
const Testimonial = require("../models/Testimonial");
const ServiceTestimonial = require("../models/ServiceTestimonial");

const index = async (req, res) => {
  try {
    const { serviceId } = req.query; // or req.params depending on your route

    let whereCondition = {};
    if (serviceId) {
      whereCondition = { serviceId }; // filter by service
    }

    const testimonials = await Testimonial.findAll({ where: whereCondition });

    return res.json(testimonials);
  } catch (error) {
    console.error("Error fetching testimonials:", error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};


const getAllTestimonial = async (req, res) => {
  try {
    const page = req.query.page ? req.query.page : 1;
    const pageSize = req.query.pageSize ? req.query.pageSize : 75;
    const testimonials = await Testimonial.findAndCountAll({
      where: {
        ...(req.query.search && {
          [Op.or]: [{ createdBy: { [Op.regexp]: req.query.search } }],
        }),
      },
      order: [["createdOn", "DESC"]],
      limit: parseInt(pageSize),
      offset: (parseInt(page) - 1) * parseInt(pageSize),
    });
    const total = Math.ceil(testimonials.count / pageSize);
    return res.status(201).json({
      filters: { page: parseInt(page), nextPage: parseInt(page) + 1, total },
      testimonials: testimonials.rows,
    });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};


const getServiceTestimonial = async (req, res) => {
  try {
    const page = req.query.page ? req.query.page : 1;
    const pageSize = req.query.pageSize ? req.query.pageSize : 4;
    const testimonials = await ServiceTestimonial.findAndCountAll({
      where: {
        ...(req.query.search && {
          [Op.or]: [{ createdBy: { [Op.regexp]: req.query.search } }],
        }),
      },
      order: [["createdOn", "DESC"]],
      limit: parseInt(pageSize),
      offset: (parseInt(page) - 1) * parseInt(pageSize),
    });
    const total = Math.ceil(testimonials.count / pageSize);
    return res.status(201).json({
      filters: { page: parseInt(page), nextPage: parseInt(page) + 1, total },
      testimonials: testimonials.rows,
    });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};
const createTestimonial = async (req, res) => {
  const { userId, isActive, createdBy, createdOn, reviewDescription , Title } =
    req.body;

  try {
    // Create a new testimonial
    const testimonial = await Testimonial.create({
      userId,
      Title,
      isActive,
      createdBy,
      createdOn,
      reviewDescription,
    });

    // If testimonial is successfully created, send a success response
    res
      .status(201)
      .json({ message: "Testimonial created successfully", testimonial });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

const createServiceTestimonial = async (req, res) => {

  console.log("servicetest",req.body)
  const { userId, isActive, createdBy, createdOn, reviewDescription ,serviceId } =
    req.body;

  try {
    // Create a new testimonial
    const testimonial = await ServiceTestimonial.create({
      userId,
      isActive,
      createdBy,
      createdOn,
      reviewDescription,
      serviceId 
    });

    // If testimonial is successfully created, send a success response
    res
      .status(201)
      .json({ message: "Testimonial created successfully", testimonial });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

const updateTestimonial = async (req, res) => {
  const { id } = req.params;
  const { userId, isActive, createdBy, createdOn, reviewDescription } =
    req.body;

  try {
    await Testimonial.update(
      { userId, isActive, createdBy, createdOn, reviewDescription },
      { where: { id: id } }
    );

    res.status(200).json({ message: "Testimonial updated successfully" });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

const updateServiceTestimonial = async (req, res) => {
  const { id } = req.params;
  const { userId, isActive, createdBy, createdOn, reviewDescription , serviceId } =
    req.body;
console.log("id",id);
console.log("bidy",req.body)
  try {
    await ServiceTestimonial.update(
      { userId, isActive, createdBy, createdOn, reviewDescription , serviceId},
      { where: { id: id } }
    );

    res.status(200).json({ message: "Testimonial updated successfully" });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

const deleteestimonial = async (req, res) => {
  try {
    const { id } = req.params;
    const contact = await Testimonial.findByPk(id);

    if (!contact) {
      return res.status(404).json({ error: "Contact not found" });
    }

    await contact.destroy();
    res.status(200).json({ message: "Testimonial deleted successfully" });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

const deleteService = async (req, res) => {
  try {
    const { id } = req.params;
    const contact = await ServiceTestimonial.findByPk(id);

    if (!contact) {
      return res.status(404).json({ error: "Contact not found" });
    }

    await contact.destroy();
    res.status(200).json({ message: "Testimonial deleted successfully" });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

const updatesTestimonial = async (req, res) => {
  const { id } = req.params; 
  const { createdBy, reviewDescription, userId, isActive, createdOn , Title } = req.body;

  try {
   
    const testimonial = await Testimonial.findOne({ where: { id } });

    if (!testimonial) {
      return res.status(404).json({ message: "Testimonial not found" });
    }

   
     testimonial.Title = Title || testimonial.Title;
    testimonial.createdBy = createdBy || testimonial.createdBy;
    testimonial.reviewDescription = reviewDescription || testimonial.reviewDescription;
    testimonial.userId = userId || testimonial.userId;
    
    
    testimonial.isActive = isActive !== undefined ? isActive : testimonial.isActive;
    testimonial.createdOn = createdOn || testimonial.createdOn;

    
    await testimonial.save();


    res.status(200).json({ message: "Testimonial updated successfully", testimonial });
  } catch (error) {
    console.error("Error updating testimonial:", error);
    res.status(500).json({ message: "Internal server error" });
  }
};




module.exports = {
  index,
  getAllTestimonial,
  createTestimonial,
  deleteestimonial,
  updateTestimonial,
  updatesTestimonial,
  createServiceTestimonial,
  updateServiceTestimonial,
  deleteService,
  getServiceTestimonial
};
