const paypal = require("@paypal/checkout-server-sdk");
const client = require("../config/paypal");

module.exports = {
  async createOrder(req, res) {
    try {
      const request = new paypal.orders.OrdersCreateRequest();
      request.requestBody({
        intent: "CAPTURE",
        purchase_units: [
          {
            amount: {
              currency_code: "USD",
              value: req.body.amount,
            },
          },
        ],
      });
      const order = await client.execute(request);
      return res.json({ result: order.result });
    } catch (err) {
      console.error(err);
      return res.status(400).json({ message: "Error creating order" });
    }
  },

  async captureOrder(req, res) {
    try {
      const request = new paypal.orders.OrdersCaptureRequest(
        req.params.orderId
      );
      request.requestBody({});
      const capture = await client.execute(request);
      return res.json(capture);
    } catch (err) {
      console.error(err);
      return res.status(400).json({ message: "Error capturing order" });
    }
  },
};
