const Notification = require("../models/Notification");
const User = require("../models/User");

module.exports = {

  async index(req, res) {
    try {
      // pull user id from auth middleware
      const authUserId = req.user?.userid || req.user?.id;

      if (!authUserId) {
        return res.status(401).json({ error: "Unauthorized: user not found" });
      }

      const notifications = await Notification.findAll({
        where: { user_id: authUserId }, // filter by logged-in user
        include: [{ model: User, as: "user" }],
        order: [["createdAt", "DESC"]],
      });

      return res.json(notifications);
    } catch (error) {
      console.error("Error fetching notifications:", error);
      res.status(500).json({ error: "Internal Server Error" });
    }
  },

  /**
   * Mark a notification as read
   */
  async updateNotification(req, res) {
    try {
      const authUserId = req.user?.userid || req.user?.id;

      if (!authUserId) {
        return res.status(401).json({ error: "Unauthorized" });
      }

      const [updated] = await Notification.update(
        { read: true },
        {
          where: {
            id: req.params.id,
            userId: authUserId, // ✅ ensure the notification belongs to the logged-in user
          },
        }
      );

      if (updated === 0) {
        return res.status(404).json({ error: "Notification not found" });
      }

      return res.json({ message: "Notification marked as read" });
    } catch (error) {
      console.error("Error updating notification:", error);
      res.status(500).json({ error: "Internal Server Error" });
    }
  },
};
