// controller/memorialTribute.controller.js
const { Op } = require("sequelize");
const { Traibute, Memorial, User } = require("../models");

// ✅ Get all memorial tributes
const getAllMemorialTributes = async (req, res) => {
  try {
    const page = req.query.page ? parseInt(req.query.page) : 1;
    const pageSize = req.query.pageSize ? parseInt(req.query.pageSize) : 4;

    const tributes = await Traibute.findAndCountAll({
      where: {
        postType: "memorial",
        ...(req.query.search && {
          [Op.or]: [
            { createdBy: { [Op.like]: `%${req.query.search}%` } },
            { "$memorial.title$": { [Op.like]: `%${req.query.search}%` } },
            { "$author.firstName$": { [Op.like]: `%${req.query.search}%` } },
            { "$author.lastName$": { [Op.like]: `%${req.query.search}%` } },
          ],
        }),
      },
      order: [["CreatedOn", "DESC"]],
      limit: pageSize,
      offset: (page - 1) * pageSize,
      include: [
        { model: Memorial, as: "memorial", attributes: ["id", "Firstname", "Lastname"] },
        { model: User, as: "author", attributes: ["userid", "firstName", "lastName", "email"] },
      ],
    });

    const total = Math.ceil(tributes.count / pageSize);

    return res.status(200).json({
      filters: {
        page,
        nextPage: page + 1,
        total,
      },
      tributes: tributes.rows,
    });
  } catch (error) {
    console.error("getAllMemorialTributes error:", error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

// ✅ Delete a memorial tribute by id
const deleteMemorialTribute = async (req, res) => {
  try {
    const { id } = req.params;
    const tribute = await Traibute.findOne({
      where: { id, postType: "memorial" },
    });

    if (!tribute) {
      return res.status(404).json({ message: "Tribute not found" });
    }

    await tribute.destroy();
    return res.status(200).json({ message: "Memorial tribute deleted successfully" });
  } catch (error) {
    console.error("deleteMemorialTribute error:", error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};
// GET single tribute
const getMemorialTribute = async (req, res) => {
  try {
    const tribute = await Traibute.findOne({
      where: { id: req.params.id, postType: "memorial" },
      include: [
        { model: Memorial, as: "memorial", attributes: ["id", "title"] },
        { model: User, as: "author", attributes: ["userid", "firstName", "lastName", "email"] },
      ],
    });

    if (!tribute) {
      return res.status(404).json({ message: "Tribute not found" });
    }

    res.json(tribute);
  } catch (error) {
    console.error("getMemorialTribute error:", error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

// UPDATE tribute
const updateMemorialTribute = async (req, res) => {
  try {
    const { id } = req.params;
    const { traibuteIcon, reviewDescription } = req.body;

    const tribute = await Traibute.findOne({ where: { id, postType: "memorial" } });

    if (!tribute) {
      return res.status(404).json({ message: "Tribute not found" });
    }

    tribute.traibuteIcon = traibuteIcon || tribute.traibuteIcon;
    tribute.reviewDescription = reviewDescription || tribute.reviewDescription;

    await tribute.save();

    res.json({ message: "Tribute updated successfully", tribute });
  } catch (error) {
    console.error("updateMemorialTribute error:", error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

module.exports = {
  getAllMemorialTributes,
  deleteMemorialTribute,
  getMemorialTribute,
  updateMemorialTribute,
};
