// utils/socket.js
let ioInstance;

export const initSocket = (server) => {
  import('socket.io').then(({ Server }) => {
    ioInstance = new Server(server, {
      cors: { origin: '*' },
    });

    ioInstance.on('connection', (socket) => {
      console.log('New client connected', socket.id);

      // Example listener
      socket.on('disconnect', () => {
        console.log('Client disconnected', socket.id);
      });
    });
  });
};

export const getSocket = () => {
  if (!ioInstance) throw new Error('Socket.io not initialized');
  return ioInstance;
};
