import express from 'express';
import http from 'http';
import https from 'https';
import fs from 'fs';
import cors from 'cors';
import dotenv from 'dotenv';
import connectDB from './config/db.js';
import authRoutes from './routes/authRoutes.js';
import clientRoutes from './routes/clientRoutes.js';
import locationRoutes from './routes/locationRoutes.js';
import serviceProviderRoutes from './routes/serviceProviderRoutes.js';
import serviceRoutes from './routes/serviceRoutes.js';
import userRoutes from './routes/userRoutes.js';
import { initSocket } from './utils/socket.js';
import packageRoutes from "./routes/packageRoutes.js";
import clientHistoryRoutes from './routes/clientHistory.js';
import formRoutes from "./routes/formRoutes.js";
import formSchemaRoutes from "./routes/formSchemaRoutes.js";
 
dotenv.config();
connectDB();
 
const app = express();
 
// Middleware
app.use(cors());
app.use(express.json());
app.use('/uploads', express.static('uploads'));
 
// Routes
app.use('/api/auth', authRoutes);
app.use('/api/auth', locationRoutes);
app.use('/api/auth', serviceProviderRoutes);
app.use('/api/auth', serviceRoutes);
app.use('/api/auth', userRoutes);
app.use('/api/client', clientRoutes);
app.use("/api/package", packageRoutes);
app.use('/api/report', clientHistoryRoutes);
app.use("/api/form", formRoutes);
app.use("/api/schema",formSchemaRoutes);

const PORT = process.env.PORT || 5000;

// Load SSL files
const sslOptions = {
  key: fs.readFileSync(process.env.SSL_KEY_PATH),
  cert: fs.readFileSync(process.env.SSL_CERT_PATH),
  ca: fs.readFileSync(process.env.SSL_CA_PATH)
};

// Create HTTPS server
const httpsServer = https.createServer(sslOptions, app);

// Initialize socket with HTTPS server
initSocket(httpsServer);

httpsServer.listen(PORT, () =>
  console.log(`🚀 HTTPS Server running on port ${PORT}`)
);
