import express from "express";
import { createPackage, deleteIssuedPackage , updateAssignedPackageClients , getAssignedPackageClients , deletePackageById, updateIssuedPackage , getAllPackage , savePackageServices , getPackageServices , getPackageById , getIssuedPackage , updatePackageById , issuePackage , assignPackageToClients} from "../controllers/packageController.js";
import upload  from '../middleware/upload.js';

const router = express.Router();

router.post("/create", upload.single('image'), createPackage);
router.get("/memberships", getAllPackage);
router.get('/:id', getPackageById); 

router.post("/package-services", savePackageServices);           
router.get("/package-services/:id", getPackageServices);


router.post("/issue", issuePackage);

router.post('/assign-package', assignPackageToClients);

router.delete('/:id', deletePackageById);

router.put('/edit/:id', upload.single('image'), updatePackageById);

router.get("/issued-package/:id", getIssuedPackage);

router.put("/issued-package/:id", updateIssuedPackage);

router.get('/assign-package/:packageId', getAssignedPackageClients);

router.put('/assign-package/:packageId', updateAssignedPackageClients);
router.delete('/issued-package/:id', deleteIssuedPackage);





export default router;
