// routes/formSchemaRoutes.js
import express from "express";
import { saveFormSchema ,getPendingSchemas,approveSchema ,rejectSchema,getSingleSchema,getApprovedSchemas} from "../controllers/formSchemaController.js";
import { protect } from "../middleware/authMiddleware.js";

const router = express.Router();

router.post("/save-form-schema", protect, saveFormSchema); // ✅ protected

router.get("/pending", protect, getPendingSchemas);
router.put("/approve/:id", protect, approveSchema);
router.put("/reject/:id", protect, rejectSchema);
router.get("/single/:id", protect, getSingleSchema);
router.get("/approved", protect, getApprovedSchemas);

export default router;
