import express from 'express';
import {
  
  loginUser,
  forgotPassword,
  resetPassword,
  changePassword,
  editProfile,
  saveProviderLocations,
  updateLocation,
  deleteCategory,
  getServiceById,
  deleteLocation,
  createClient,
  getClients,
  updateProviderLocations,
  blockClient
} from '../controllers/authController.js';
import { protect } from '../middleware/authMiddleware.js';

import  upload  from '../middleware/upload.js';

const router = express.Router();

// router.post('/register', registerUser);
// router.get('/register/user', getRegisterUser);
router.post('/login', loginUser);
router.post('/forgot-password', forgotPassword);
router.post('/reset-password', resetPassword);
router.post('/change-password', protect, changePassword);
router.put('/edit-profile', protect, editProfile);
// router.delete('/users/:id',deleteUser);
// router.put('/users/:id',EditRegistration);
// router.post('/categories',Categoryregistration);
// router.post('/category-services', saveCategoryServices);
// router.get('/category',GetsaveCategoryServices);
// router.post('/service', createService);
// router.post('/location', upload.single('image'), createLocation);
// router.get('/locations', getAllLocations);
// router.post('/location-providers', saveLocationProviders); 
// router.post('/service-providers', saveServiceProvider);
// router.get('/get/service-providers', getServiceProviders);
// router.post('/provider-services', saveProviderServices);
router.post('/provider-locations', saveProviderLocations);
// router.post('/service-page-provider',ServicePage)
// router.post("/service-time", createServiceTime );
// router.put('/categories/:id', updateCategory);
// router.put('/category-services/:id', updateCategoryServices);
// router.get('/services', getService); // Get all
router.put('/location/:id', upload.single('image'), updateLocation);
router.delete('/delete-category/:id', deleteCategory);
router.get('/services/:id', getServiceById);
// router.put('/service/:id', updateService);
router.delete("/locations/:id", deleteLocation); 

router.post('/client', upload.single('image'), createClient);
router.get('/get/client', getClients);

// router.get("/service-provider/:id", getServiceProviderById);
// router.put('/service-providers/:id', updateServiceProvider);
// router.put('/provider-services/:id', updateProviderServices);
router.put("/provider-locations/:id", updateProviderLocations);

router.put('/block/client/:id', blockClient);



export default router;
