import mongoose from 'mongoose';

const userSchema = new mongoose.Schema({
  email: { type: String, required: true, unique: true },
  password: { type: String, required: true },
  firstName: { type: String, required: true },
  lastName: { type: String },
  countryCode: { type: String, default: '+92', required: true },
  phone: { type: String, required: true },
  sendLoginInfo: { type: Boolean, default: false },
  resetToken: String,
  resetTokenExpire: Date,
  role: {
    type: String,
    enum: ['doctor', 'patient', 'receptionist','admin'],
    default: 'patient',
    required: true
  },
  permissions: [String] ,
   createdBy: {
  type: mongoose.Schema.Types.ObjectId,
  ref: 'User',
}
}, { timestamps: true });

export default mongoose.model('User', userSchema);
