import mongoose from "mongoose";

const issuedPackageSchema = new mongoose.Schema({
  packageId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "Package",
    required: true,
  },
  serviceName: {
    type: String,
    required: true,
  },
  duration: {
    value: { type: Number, required: true },
    unit: { type: String, enum: ["day", "months", "year"], required: true },
  },
  startDate: {
    type: Date,
    required: true,
  },
  createdAt: {
    type: Date,
    default: Date.now,
  },
});

export default mongoose.model("IssuedPackage", issuedPackageSchema);
