import mongoose from 'mongoose';

const ClientHistorySchema = new mongoose.Schema({
  clientId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true
  },
  fullName: String,
  email: String,
  dni: String,
  dob: Date,
  age: Number,
  workplace: String,
  occupation: String,
  mobile: String,
  address: String,
  referredBy: String,
  physician: String,
  emergencyContact: String,
  relationship: String,
  emergencyPhone: String,

  generalHistory: String,
  personalHistory: String,
  pregnancy: String,
  gestation: String,

  otherHistory: String,
  habits: String,
  dominance: String,
  sports: String,
  sportType: String,
  sportPerformance: String,

  dietType: String,
  dietRating: String,
  breakfast: String,
  lunch: String,
  dinner: String,
  water: String,

  evacuateDaily: String,
  constipation: String,

  sleepHours: Number,
  refreshed: String,

  energy: String,
  stress: String,
  stressHandling: String,
  feelingToday: String
}, { timestamps: true });

export default mongoose.model('ClientHistory', ClientHistorySchema);
