import ClientHistory from '../models/ClientHistory.js';

export const createHistory = async (req, res) => {
  try {
    const history = await ClientHistory.create(req.body);
    res.status(201).json({ message: 'History saved successfully', history });
  } catch (err) {
    console.error('Error creating history:', err);
    res.status(500).json({ error: 'Internal Server Error' });
  }
};

export const getClientHistory = async (req, res) => {
  try {
    const { clientId } = req.params;
    const history = await ClientHistory.find({ clientId }).sort({ createdAt: -1 });
    res.status(200).json({ history });
  } catch (err) {
    console.error('Error fetching history:', err);
    res.status(500).json({ error: 'Internal Server Error' });
  }
};


// PUT /report/history/:id
export const updateHistory = async (req, res) => {
  const { id } = req.params;

  try {
    const updated = await ClientHistory.findByIdAndUpdate(id, req.body, {
      new: true, // return the updated document
      runValidators: true,
    });

    if (!updated) {
      return res.status(404).json({ error: 'History not found' });
    }

    res.status(200).json({ message: 'History updated successfully', history: updated });
  } catch (err) {
    console.error('Error updating history:', err);
    res.status(500).json({ error: 'Internal Server Error' });
  }
};
