import express from 'express';
import {
  getServiceById,
  GetsaveCategoryServices,
  updateService,
  createService,
  createServiceTime,
  ServicePage,
 updateServiceTime,
  Categoryregistration,
  updateCategory,
  updateCategoryServices,
  saveCategoryServices
} from '../controllers/serviceController.js';
import { protect } from '../middleware/authMiddleware.js';

import  upload  from '../middleware/upload.js';

const router = express.Router();

router.get('/services/:id', getServiceById);
router.get('/category',GetsaveCategoryServices);

router.put('/service/:id', updateService);

router.post('/service', createService);

router.post("/service-time", createServiceTime );

router.post('/service-page-provider',ServicePage);

router.post('/categories',Categoryregistration);

router.put('/categories/:id', updateCategory);

router.put('/category-services/:id', updateCategoryServices);


router.post('/category-services', saveCategoryServices);

router.put("/service-time/:id", updateServiceTime);



export default router;