import mongoose from 'mongoose';

const userDetailsSchema = new mongoose.Schema({
  userId: { type: mongoose.Schema.Types.ObjectId, ref: 'User', required: true },

  address1: String,
  address2: String,
  zip: String,
  city: String,
  country: String,
  tag: String,
  isBlocked: { type: Boolean, default: false },
  deporte: String,
  subjective: String,
  objective: String,
  assessment: String,
  plan: String,
  medicalHistory: String,
  image: String, // image path if uploading
}, { timestamps: true });

export default mongoose.model('UserDetails', userDetailsSchema);
