
import mongoose from 'mongoose';

const ServiceProviderSchema = new mongoose.Schema({
  name: { type: String, required: true },
  description: String,
  phone: String,
  email: String,
  image: String, // If you support image URL saving
  clientsAtOnce: Number,
  showOnBooking: { type: Boolean, default: true },
  createdAt: { type: Date, default: Date.now }
});

const ServiceProvider = mongoose.model('ServiceProvider', ServiceProviderSchema);
export default ServiceProvider
