import mongoose from 'mongoose';

const LocationProviderSchema = new mongoose.Schema({
  locationId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Location',
    required: true
  },
  providers: [
    {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'ServiceProvider', // <-- replace with your actual Provider model name
    }
  ]
}, { timestamps: true });

export default mongoose.model('LocationProvider', LocationProviderSchema);
