import mongoose from 'mongoose';

const locationSchema = new mongoose.Schema({
  locationName: { type: String, required: true },
  description: { type: String },
  image: { type: String },
  isVisible: { type: Boolean, default: true },
  isDefault: { type: Boolean, default: false },
  position: { type: String, enum: ['first', 'last'], default: 'last' },
  address: {
    phone: String,
    address1: String,
    address2: String,
    city: String,
    zip: String,
    country: String,
  },
}, { timestamps: true });

const Location = mongoose.model('Location', locationSchema);
export default Location;

