import mongoose from 'mongoose';
import Category from '../models/Category.js';

const categoryServiceSchema = new mongoose.Schema({
  categoryId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Category',
    required: true
  },
  services: [
    {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'Service' // Optional: If you have a Service model
    }
  ]
  
});

const CategoryService = mongoose.model('CategoryService', categoryServiceSchema);
export default CategoryService;
