import User from '../models/User.js';
import bcrypt from 'bcryptjs';

export const getRegisterUser = async (req, res) => {
  try {
    const users = await User.find({ role: { $ne: "admin" } })
      .select('-password')
      .sort({ createdAt: -1 }); // ✅ newest users first

    res.status(200).json(users);
  } catch (err) {
    console.error('Error fetching users:', err);
    res.status(500).json({ message: 'Server error while fetching users' });
  }
};


export const deleteUser =async (req,res) => {

 try {
    const userId = req.params.id;
console.log("userid",userId);
const objectId = new mongoose.Types.ObjectId(userId);


    const deletedUser = await User.findByIdAndDelete(objectId);
    console.log("deletedUser",deletedUser);
    

    if (!deletedUser) {
      return res.status(404).json({ status: false, message: 'User not found' });
    }

    return res.status(200).json({ status: true, message: 'User deleted successfully' });
  } catch (error) {
    console.error('Delete user error:', error);
    return res.status(500).json({ status: false, message: 'Server error' });
  }
};


export const EditRegistration = async (req, res) => {
  const userId = req.params.id;
  const updatedData = req.body;

  try {
    const user = await User.findByIdAndUpdate(
      userId,
      updatedData,
      { new: true, runValidators: true }
    );

    if (!user) {
      return res.status(404).json({ status: false, message: 'User not found' });
    }

    res.status(200).json({ status: true, message: 'User updated successfully', user });
  } catch (error) {
    console.error('Update error:', error);
    res.status(500).json({ status: false, message: 'Error updating user', error });
  }
}


export const registerUser = async (req, res) => {
  console.log("Request body:", req.body);

  const {
    email,
    role,
    password,
    verifyPassword,
    countryCode,
    phone,
    firstName,
    lastName,
    sendLoginInfo,
  } = req.body;

  try {
    // Check if email already exists
    const existingUser = await User.findOne({ email });
    if (existingUser) {
      return res.status(400).json({
        status: false,
        message: "Email already exists",
      });
    }

    // Validate password match
    if (password !== verifyPassword) {
      return res.status(400).json({
        status: false,
        message: "Passwords do not match",
      });
    }

    // Hash password
    const hashedPassword = await bcrypt.hash(password, 10);

    // Create new user
    const user = await User.create({
      email,
      role: role.toLowerCase(),
      password: hashedPassword,
      countryCode,
      phone,
      firstName,
      lastName,
      sendLoginInfo,
    });

    res.status(201).json({
      status: true,
      message: "User registered successfully",
      userId: user._id,
    });
  } catch (err) {
    console.error("Registration Error:", err);
    res.status(500).json({
      status: false,
      message: "Server error",
      error: err.message,
    });
  }
};
