import express from 'express';
import {
    createLocation,
    updateLocation,
    getServiceProviders,
    saveLocationProviders,
    getAllLocations,
    getServiceProviderById,
   updateLocationProviders,
    deleteLocation
 
} from '../controllers/locationController.js';

import { protect } from '../middleware/authMiddleware.js'; // optional if needed
import { uploadSingle } from '../utils/uploadHelper.js';

import  upload  from '../middleware/upload.js';

const router = express.Router();

router.post('/location', upload.single('image'), createLocation);

router.put('/location/:id', upload.single('image'), updateLocation);

router.get('/get/service-providers', getServiceProviders);

router.post('/location-providers', saveLocationProviders); 
router.put('/update/location-providers/:locationId', updateLocationProviders); 


router.get('/locations', getAllLocations);

router.get("/service-provider/:id", getServiceProviderById);

// router.post('/service-providers', saveServiceProvider);

router.delete("/locations/:id", deleteLocation); 




export default router;