import mongoose from 'mongoose';

const ProviderServiceSchema = new mongoose.Schema(
  {
    providerId: {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'ServiceProvider',
      required: true,
      unique: true,
    },
    services: [
      {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Service', // <-- Make sure this matches your actual Service model name
      },
    ],
  },
  {
    timestamps: true,
  }
);

export default mongoose.model('ProviderService', ProviderServiceSchema);
