const express = require("express");
const PDFDocument = require("pdfkit");
const {
  signUp,
  signIn,
  forgotPassword,
  resetPassword,
  deleteUserById,
  updateUser,
  loginByToken,
  allUsers,
  allProviders,
  updateUserType,
  findUserByEmail,
  getSingleUser,
  index,
  getUserTypes,
  getAdminsAndServiceProviders,
} = require("../controller/userController");
const { sendMail } = require("../controller/mailController");
const { authenticateToken } = require("../middlewares/user.middleware");
const passport = require("passport");
const router = express.Router();

router.post("/signup", signUp);
router.post("/login", signIn);
router.delete("/deleteusers/:id", deleteUserById);
router.put(
  "/updateUser/:id",
  passport.authenticate("jwt", { session: false }),
  updateUser
);
router.put("/update-type/:id", updateUserType);

/* GET users listing. */
router.get("/admins-service-providers", getAdminsAndServiceProviders);
router.get("/allusers", allUsers);
router.get("/allproviders", allProviders);
router.get("/types", getUserTypes);
router.get("/single-user/:id", getSingleUser);
router.get("/find-by-email", findUserByEmail);
router.get("/", index);

module.exports = router;
