const express = require("express");
const {
  getAllTraibute,
  createTraibute,
  removeTribute,
  getAllMemorialTraibuteById,
  getAllObituaryTraibuteById,
  getSingleTribute,
  updateTribute,
  getTributesByUser,
} = require("../controller/tributeController");
const { checkTributeOwner } = require("../middlewares/user.middleware");
const passport = require("passport");
const router = express.Router();

router.get("/all", getAllTraibute);
router.get("/by-user/:userId", getTributesByUser);
router.get("/memorial/:memorail_id", getAllMemorialTraibuteById);
router.get("/obituary/:memorail_id", getAllObituaryTraibuteById);
router.get("/single/:id", getSingleTribute);
router.put("/update/:id", updateTribute);

router.post(
  "/createTraibute",
  passport.authenticate("jwt", { session: false }),
  createTraibute
);
router.delete(
  "/remove/:id",
  passport.authenticate("jwt", { session: false }),
  checkTributeOwner,
  removeTribute
);

module.exports = router;
