const express = require("express");
const router = express.Router();
const passport = require("passport");

const {
  create,
  allPromocodes,
  removeCoupon,
  findCoupon,
} = require("../controller/coupons");
const { checkSuperAdmin } = require("../middlewares/user.middleware");

router.post(
  "/create",
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  create
);

router.get("/find/:code", findCoupon);

router.get(
  "/",
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  allPromocodes
);

router.delete(
  "/remove/:id",
  passport.authenticate("jwt", { session: false }),
  checkSuperAdmin,
  removeCoupon
);

module.exports = router;
